<?php if(isset($paginator) && $paginator->lastPage() > 1): ?>

	<nav aria-label="Page navigation example">
		<ul class="pagination pagination-sm justify-content-center mymargin5">
        
	<?
		$interval = isset($interval) ? abs(intval($interval)) : 2 ;
		$from = $paginator->currentPage() - $interval;
		if ($from < 1)	$from = 1;
			
		$to = $paginator->currentPage() + $interval;
		if ($to > $paginator->lastPage()) $to = $paginator->lastPage();
	?>
        
	<?php if($paginator->currentPage() > 1): ?>		<!-- 처음, 이전 -->
		<li class="page-item">
			<a class="page-link" href="<?php echo e($paginator->url(1)); ?>" aria-label="First">
				<span aria-hidden="true" style="color:steelblue">◀</span>
			</a>
		</li>

		<li class="page-item">
			<a class="page-link" href="<?php echo e($paginator->url($paginator->currentPage() - 1)); ?>" aria-label="Previous">
				<span aria-hidden="true" style="color:steelblue">◁</span>
			</a>
		</li>
	<?php endif; ?>
     
	<?php for($i = $from; $i <= $to; $i++): ?>				<!--  페이지번호들... -->
	<?
		$isCurrentPage = $paginator->currentPage() == $i;
	?>
		<li class="page-item <?php echo e($isCurrentPage ? 'active' : ''); ?>">
	<?php if( !$isCurrentPage): ?>
			<a class="page-link" href="<?php echo e($paginator->url($i)); ?>" style="color:#666666"><?php echo e($i); ?></a>
	<?php else: ?>
			<a class="page-link" href="#" style="color:white;background-color:steelblue"><?php echo e($i); ?></a>
	<?php endif; ?>

		</li>
	<?php endfor; ?>
        
	<?php if($paginator->currentPage() < $paginator->lastPage()): ?>	<!-- 다음, 끝 -->
		<li class="page-item">
			<a class="page-link" href="<?php echo e($paginator->url($paginator->currentPage() + 1)); ?>" aria-label="Next">
				<span aria-hidden="true" style="color:steelblue">▷</span>
			</a>
		</li>

		<li class="page-item">
			<a class="page-link" href="<?php echo e($paginator->url($paginator->lastpage())); ?>" aria-label="Last">
				<span aria-hidden="true" style="color:steelblue">▶</span>
			</a>
		</li>
	<?php endif; ?>
        
		</ul>
	</nav>

<?php endif; ?><?php /**PATH C:\APM\Apache24\htdocs\sale\resources\views/mypagination.blade.php ENDPATH**/ ?>